/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.etcetera.client.gui.screen;

import com.google.common.collect.Lists;
import com.ninni.etcetera.client.gui.screen.PricklyCanScreenHandler;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PricklyCanScreen
extends AbstractContainerScreen<PricklyCanScreenHandler> {
    static final ResourceLocation TEXTURE = new ResourceLocation("etcetera", "textures/gui/container/prickly_can.png");
    private final List<PricklyCanButtonWidget> buttons = Lists.newArrayList();

    public PricklyCanScreen(PricklyCanScreenHandler handler, Inventory inventory, Component title) {
        super((AbstractContainerMenu)handler, inventory, title);
        ++this.f_97727_;
    }

    public void m_88315_(GuiGraphics context, int mouseX, int mouseY, float delta) {
        this.m_280273_(context);
        super.m_88315_(context, mouseX, mouseY, delta);
        this.m_280072_(context, mouseX, mouseY);
    }

    protected void m_181908_() {
        super.m_181908_();
        this.buttons.forEach(PricklyCanButtonWidget::tick);
    }

    protected void m_7286_(GuiGraphics context, float delta, int mouseX, int mouseY) {
        this.m_280273_(context);
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        context.m_280218_(TEXTURE, i, j, 0, 0, this.f_97726_, this.f_97727_);
    }

    private <T extends AbstractWidget> void addButton(T button) {
        this.m_142416_((GuiEventListener)button);
        this.buttons.add((PricklyCanButtonWidget)button);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.buttons.clear();
        this.addButton(new DeleteButtonWidget(this.f_97735_ + 159, this.f_97736_ + 3));
    }

    protected void m_280003_(GuiGraphics context, int mouseX, int mouseY) {
        super.m_280003_(context, mouseX, mouseY);
        for (PricklyCanButtonWidget button : this.buttons) {
            if (!button.shouldRenderTooltip()) continue;
            context.m_280557_(this.f_96547_, (Component)Component.m_237115_((String)"etcetera.container.prickly_can_delete"), mouseX - this.f_97735_, mouseY - this.f_97736_);
            break;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static interface PricklyCanButtonWidget {
        public boolean shouldRenderTooltip();

        public void tick();
    }

    @OnlyIn(value=Dist.CLIENT)
    class DeleteButtonWidget
    extends BaseButtonWidget {
        public DeleteButtonWidget(int x, int y) {
            super(x, y, (Component)Component.m_237115_((String)""));
        }

        @Override
        public void tick() {
            this.setDisabled(((PricklyCanScreenHandler)PricklyCanScreen.this.m_6262_()).getContainer().m_7983_());
        }

        public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
            if (this.f_93623_ && this.f_93624_) {
                if (keyCode != 257 && keyCode != 32 && keyCode != 335) {
                    return false;
                }
                if (!this.isDisabled()) {
                    this.m_7435_(Minecraft.m_91087_().m_91106_());
                }
                this.m_5691_();
                return true;
            }
            return false;
        }

        public void m_5691_() {
            ((PricklyCanScreenHandler)PricklyCanScreen.this.m_6262_()).m_6366_((Player)((PricklyCanScreen)PricklyCanScreen.this).f_96541_.f_91074_, 1);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static abstract class BaseButtonWidget
    extends AbstractButton
    implements PricklyCanButtonWidget {
        private boolean disabled;

        protected BaseButtonWidget(int x, int y, Component message) {
            super(x, y, 13, 13, message);
        }

        public void m_88315_(GuiGraphics context, int mouseX, int mouseY, float delta) {
            int j = 176;
            if (this.disabled) {
                j += 26;
            } else if (this.m_274382_()) {
                j += 13;
            }
            context.m_280218_(TEXTURE, this.m_252754_(), this.m_252907_(), j, 0, this.f_93618_, this.f_93619_);
        }

        public boolean isDisabled() {
            return this.disabled;
        }

        public void setDisabled(boolean disabled) {
            this.disabled = disabled;
        }

        @Override
        public boolean shouldRenderTooltip() {
            return this.f_93622_;
        }

        public void m_168797_(NarrationElementOutput output) {
            this.m_168802_(output);
        }
    }
}

